1001
%{
#include "StdH.h"
#include <Entities/Common/Flags.h>
#include <Help/SDK/Models/Blob/Blob.h>
%}

class CBlob : CMovableModelEntity {
name      "Blob";
thumbnail "Help\\SDK\\Models\\Blob\\Blob.tbn";

properties:

components:
  1 model   MODEL_BLOB     "Help\\SDK\\Models\\Blob\\Blob.mdl",
  2 texture TEXTURE_BLOB   "Help\\SDK\\Models\\Blob\\Blob.tex",
 10 texture TEX_SPEC_MEDIUM "Models\\SpecularTextures\\Medium.tex",
 11 texture TEX_REFL_LIGHTBLUEMETAL01   "Models\\ReflectionTextures\\LightBlueMetal01.tex",

functions:

procedures:
  Main()
  {
    InitAsModel();
    SetPhysicsFlags(EPF_MODEL_WALKING);
    SetCollisionFlags(ECF_MODEL);

    // set appearance
    GetModelObject()->StretchModel(FLOAT3D(0.1f,0.1f,0.1f));
    SetModel(MODEL_BLOB);
    SetModelMainTexture(TEXTURE_BLOB);
    GetModelObject()->mo_toSpecular.SetData(
      GetTextureDataForComponent(TEX_SPEC_MEDIUM));
    GetModelObject()->mo_toReflection.SetData(
      GetTextureDataForComponent(TEX_REFL_LIGHTBLUEMETAL01));

    // repeat forever
    while(TRUE) {
      // pulse jump up
      SetDesiredTranslation(FLOAT3D(0,10,0));
      autowait(0.1f);
      SetDesiredTranslation(FLOAT3D(0,0,0));

      // wait
      wait() {
        // if touched something
        on (ETouch) : {
          // stop waiting
          stop;
        }
        // ignore all other events
        otherwise() : { resume; }
      }

      // play the bouncing animation
      GetModelObject()->PlayAnim(BLOB_ANIM_MELT, 0);
      // wait for the bouncing to finish
      autowait(GetModelObject()->GetCurrentAnimLength());
      // continue in still pose
      GetModelObject()->PlayAnim(BLOB_ANIM_DEFAULT_ANIMATION, 0);

    }

    return;
  }
};

