--
-- Custom script for exporting each frame of a Max scene as a single 3ds file
-- Created by Croteam, June 2000
--
-- modify at preference
-- 

-- get file name for exporting via a fileopen dialog
strChosenName = getSaveFileName types:"3ds(*.3ds)|*.3ds|All|*.*|" 

-- strip the extension
strBaseName = (getFilenamePath strChosenName) + (getFilenameFile strChosenName)

-- start exporting mode
escapeEnable = true
progressStart "exporting..."
DisableSceneRedraw()

-- for each frame in scene
iFrame=0
for tmCounter = animationRange.start to animationRange.end do (

 -- go to that frame
 sliderTime = tmCounter
 
 -- set progress
 offset = (tmCounter - animationRange.start) as float
 total = (animationRange.end - animationRange.start) as float
 progressUpdate (offset / total * 100)
 
 -- create filename for this frame
 iDigit10 = iFrame/10
 iDigit1 = (mod iFrame 10) as integer
 str = strBaseName + (iDigit10 as string) + (iDigit1 as string) + ".3ds"
 
 -- check for user pressing escape
 if getProgressCancel() then exit

 -- export the frame
 exportFile str #noPrompt
 
 -- next frame
 iFrame = iFrame + 1
)

-- cleanup from export mode
EnableSceneRedraw()
progressEnd()

